import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42
sns.set_context("paper")
sns.set(rc={'figure.figsize':(10,6)})
types = ['union','intersection','first2','last2']
df = pd.DataFrame()

for t in types:
	temp = pd.read_csv(t+".txt",sep="\t",index_col=False,usecols=['Parent term','Fold Enrichment'])
	temp['Timepoint']=t
	df = pd.concat((df,temp))

temp = pd.read_csv('specific.txt',sep="\t",index_col=False, usecols=['Parent term','Timepoint','Fold Enrichment'])
df = pd.concat((df,temp),sort=True)
df.to_csv('fold_enrichment.txt',sep="\t",index=False)

df = df.pivot("Parent term","Timepoint","Fold Enrichment")
df = df[['day0','day2','day5','day7','day15','day80','first2','last2','union','intersection']]
sns.heatmap(df, annot=True,fmt=".2f",cmap="Reds")
plt.tight_layout()

plt.savefig('fold_enrichment.pdf')
