import numpy as np
import pandas as pd
import sys

radius = 100
timepoints = ['H1','endoderm']

T = len(timepoints)

for i in range(T):
	t1 = timepoints[i]
	for j in range(i+1,T):
		t2 = timepoints[j]
		pair = '{}vs{}'.format(t1,t2)
		df = pd.read_csv('../../rank_boundaries_{}.txt'.format(pair),sep="\t",index_col=False,usecols=['chro','start','end'])
		df = df.head(10)
		bed = pd.read_csv('all_regions.bed',sep="\t",index_col=False,header=None,usecols=[0,1,3],names=['chro','start','idx'])
		df = pd.merge(df,bed,how='inner',on=['chro','start'])
		for idx, row in df.iterrows():
			midpoint = int(row['idx'])
			start = midpoint - radius
			end = midpoint + radius
			chro = 'chr'+str(int(row['chro']))
			scores = pd.read_csv('tgif_output/{}/significant_boundaries_summit_only.txt'.format(chro), sep="\t",index_col=False)
			scores.fillna(0,inplace=True)
			scores = scores.values[start:end]
			subset = scores[:,[i,j]]
			np.savetxt('summit/{}_{:d}_summit.txt'.format(pair,idx),subset,delimiter="\t",fmt="%d")	

