import pandas as pd
import sys

chro= sys.argv[1]
middle = int(sys.argv[2])
cells = ['day00','day02','day05','day07','day15','day80']
start = middle-100 
end = middle+99

for cell in cells:
	fname = 'hic/mat/{}_{}_10kb.txt'.format(cell,chro)
	df = pd.read_csv(fname,sep="\t",header=None,names=['i','j','cnt'])
	subdf = df.loc[df['i'].between(start,end) & df['j'].between(start,end)].copy()
	subdf['i'] = subdf['i'] - start
	subdf['j'] = subdf['j'] - start
	subdf.to_csv('{}_{}_{}.txt'.format(chro,middle,cell),sep="\t",index=False,header=False)
