import pandas as pd
import numpy as np

chros = ['chr' +str(i) for i in range(1,23)]
sites = pd.read_csv('somatic_chro_regions_with_top100_txn_hervh_sites.csv',index_col=False)
alldf = pd.DataFrame()
distance = np.arange(-50000, 60000, 10000)

for c in chros:
	subsites = sites.loc[sites['chro']==c].copy()
	bed = pd.read_csv('hic/bed/{}_10kb.bed'.format(c),sep="\t",header=None,names=['chro','coord','coord_end','idx'],index_col=False)
	bed = pd.merge(subsites,bed,how="left",left_on='coord',right_on='coord')
	for _, row in bed.iterrows():
		mid = row['idx']
		start = mid-5
		end = mid+6
		bscore = pd.read_csv('db_output/{}/boundary_score.txt'.format(c),sep="\t",index_col=False)
		bscore.fillna(0,inplace=True)
		names = list(bscore.columns)
		bscore = bscore.values[start:end]
		df = pd.DataFrame(data=bscore,columns = names)
		df['distance'] = distance
		df['chro'] = c
		df['midpoint'] = mid
		alldf = pd.concat([alldf,df])

alldf.to_csv('neighborhood_score.txt',sep="\t",index=False)
		
