import numpy as np
import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42
sns.set_context("talk")

df = pd.read_csv('neighborhood_score.txt',sep="\t",index_col=False,usecols=['distance','day0','day2','day5','day7','day15','day80'])
df = df.loc[df['distance'] == 0]
df = pd.melt(df, id_vars = ['distance'],value_vars=['day0','day2','day5','day7','day15','day80'],var_name='timepoint',value_name='boundary_score')
#fig = plt.figure(figsize=(7,5))
ax = sns.barplot(data=df, x='timepoint',y='boundary_score',palette='Blues_d')
ax.set_ylabel('TGIF boundary score at HERV-H site')
ax.set_xlabel('Timepoint')
plt.tight_layout()
plt.savefig('figure_hervh_site_score.pdf')
#plt.show()
