import pandas as pd
import numpy as np

chros = ['chr' +str(i) for i in range(1,23)]
sites = pd.read_csv('somatic_chro_regions_with_top100_txn_hervh_sites.csv',index_col=False)
alldf = pd.DataFrame()

for c in chros:
	subsites = sites.loc[sites['chro']==c].copy()
	bed = pd.read_csv('hic/bed/{}_10kb.bed'.format(c),sep="\t",header=None,usecols=[1], names=['coord'],index_col=False)
	bscore = pd.read_csv('../tgif_output/{}/significant_boundaries.txt'.format(c),sep="\t",index_col=False)
	bscore.fillna(0,inplace=True)
	bb = pd.concat([bed,bscore],axis=1)
	df = pd.merge(subsites,bb,how="left",left_on='coord',right_on='coord')
	alldf = pd.concat([alldf,df])



alldf.to_csv('boundary_type.txt',sep="\t",index=False)
		
