import warnings
warnings.filterwarnings("ignore", category=DeprecationWarning) 
import pandas as pd
import numpy as np
import sys

t1 = sys.argv[1]
t2 = sys.argv[2]

chroms = range(1, 20)
res = 10000
radius = int(100000/res)

df = pd.DataFrame()

for c in chroms:
    bed = pd.read_csv('bed/ES_chr{:d}_10kb.bed'.format(c),header=None,names=['chrom','start','end','idx'],sep="\t",index_col=False)
    offset = bed.start.values[0]
    db_list = pd.read_csv('db_output/chr{:d}/{}_vs_{}_significantly_differential_boundary_regions.txt'.format(c, t1, t2),header=None,names=['chrom','start','end','distance','pval','padj'],sep="\t",index_col=False)
    n = bed.shape[0]
    affected_region = np.zeros(n,dtype=bool)
    for _,row in db_list.iterrows():
        center_idx = int((row.start - offset)/res)
        b = max(0,center_idx-radius)
        e = min(n,center_idx+radius)
        affected_region[b:e] = True
    bed['affected'] = affected_region
    df = pd.concat((df,bed))

#df.drop('idx',axis=1,inplace=True)
#print(df.shape[0],df.affected.values.sum())
#df.to_csv('within_100kb_of_sig_db.txt',sep="\t",index=False,float_format='%d')

df.end -= 1
df.chrom = 'chr'+df.chrom.map(str)
subdf = df.loc[df.affected==True]
subdf.to_csv('subsets/within_100kb_of_sig_db_{}vs{}.bed'.format(t1,t2),sep="\t",index=False,header=False,columns=['chrom','start','end'],float_format='%d')
    
