import pandas as pd
import numpy as np
import sys
from scipy.stats import hypergeom

t1=sys.argv[1]
t2=sys.argv[2]

df = pd.DataFrame()
for t in ['region','gene']:
	tmp = pd.read_csv('counts/{}_counts_{}vs{}.txt'.format(t,t1,t2),sep="\t",index_col=False)
	n = tmp.shape[0]
	fold=np.zeros(n)
	pval=np.zeros(n)
	for idx,row in tmp.iterrows():
		fold[idx]=(row.q/row.M)/(row.p/row.N)
		pval[idx]=hypergeom.sf(row.q, row.N, row.p, row.M)
	tmp['(q/M)/(p/N)'] = fold
	tmp['pval'] = pval
	df = pd.concat((df,tmp))

df.to_csv('hypergeom/{}_vs_{}.txt'.format(t1,t2),sep="\t",index=False)	
