t1=$1
t2=$2
pair="${t1}vs${t2}"
outfile="counts/gene_counts_${t1}vs${t2}.txt"
genes="all_genes.bed"
de_genes="subsets/de_genes_${pair}.bed"
intersect="/mnt/dv/wid/projects1/WID-Software/centos7/x86_64/anaconda3-2019.03/bin/bedtools intersect"

# | all genes |
N=$(wc -l $genes | awk '{print $1}')

# | DE genes |
p=$(wc -l $de_genes | awk '{print $1}')

echo -e "N\tp\tM\tq\tall(N)\texpected(p)\tsampled(M)\tsuccess(q)" > $outfile
for subset in within_100kb_of_sig_db within_tad_with_sig_db within_sig_dc AB AC BC
do
	M=$($intersect -wa -u -a $genes -b subsets/${subset}_${pair}.bed | wc -l)
	q=$($intersect -wa -u -a $de_genes -b subsets/${subset}_${pair}.bed | wc -l)
	subset_str=$(echo $subset | sed -r 's/_/ /g')
	echo -e "$N\t$p\t$M\t$q\tall genes\tDE genes\tgenes overlapping with regions $subset_str\tDE genes overlapping with regions $subset_str" >> $outfile
done


