import warnings
warnings.filterwarnings("ignore", category=DeprecationWarning) 
import pandas as pd
import numpy as np
import sys

t1 = "day"+sys.argv[1]
t2 = "day"+sys.argv[2]

chroms = range(1, 23)
res = 10000
df = pd.DataFrame()

for c in chroms:
    bed = pd.read_csv('bed/chr{:d}_10kb.bed'.format(c),header=None,names=['chrom','start','end','idx'],sep="\t",index_col=False)
    offset = bed.start.values[0]

    temp = pd.read_csv('db_output/chr{:d}/{}_vs_{}_significantly_differential_boundary_regions_DEBUG.txt'.format(c,t1,t2),header=None,names=['chrom','start','end','distance','pval','padj','diff','sigdiff'],sep="\t",index_col=False)

    all_boundaries = pd.read_csv('db_output/chr{:d}/significant_boundaries_summit_only.txt'.format(c),sep="\t",index_col=False)
    temp['common'] = ((all_boundaries[t1] + all_boundaries[t2]) == 2)
    
    n = bed.shape[0]
    affected_region = np.zeros(n,dtype=bool)
  
    last_bd_idx = 0
    last_bd_is_sigdiff = 0
    for _,row in temp.iterrows():
        if row.sigdiff == 1:
            db_idx = int((row.start - offset)/res)
            affected_region[last_bd_idx:db_idx] = True
            last_bd_idx = db_idx
            last_bd_is_sigdiff = 1
        if row.common == 1:
            bd_idx = int((row.start - offset)/res)
            if last_bd_is_sigdiff:
                affected_region[last_bd_idx:bd_idx] = True
            last_bd_idx = bd_idx
            last_bd_is_sigdiff = 0
             
    bed['affected'] = affected_region
    df = pd.concat((df,bed))

#df.drop('idx',axis=1,inplace=True)
#print(df.shape[0],df.affected.values.sum())
#df.to_csv('within_tad_with_sig_db.txt',sep="\t",index=False,float_format='%d')

df.end -= 1
df.chrom = 'chr'+df.chrom.map(str)
subdf = df.loc[df.affected==True]
subdf.to_csv('subsets/within_tad_with_sig_db_{}vs{}.bed'.format(t1,t2),sep="\t",index=False,header=False,columns=['chrom','start','end'],float_format='%d') 
