import warnings
warnings.filterwarnings("ignore", category=DeprecationWarning) 
import pandas as pd
import numpy as np
import sys

t1=sys.argv[1]
t2=sys.argv[2]
pair='day'+t1.zfill(2)+'_vs_day'+t2.zfill(2)
gene_list = pd.read_csv('de_output/gene_coordinates_with_de_pval.txt'.format(t1,t2),usecols=['chro','start','end',pair],sep="\t",index_col=False)
df = gene_list.loc[gene_list[pair] < 0.05]
df.to_csv('subsets/de_genes_day{}vsday{}.bed'.format(t1,t2),sep="\t",index=False,float_format='%d', header=False, columns=['chro','start','end'])
    
