t1="day$1"
t2="day$2"
pair="${t1}vs${t2}"
outfile="counts/region_counts_${t1}vs${t2}.txt"
de_genes="subsets/de_genes_${pair}.bed"
intersect="/mnt/dv/wid/projects1/WID-Software/centos7/x86_64/anaconda3-2019.03/bin/bedtools intersect"

# | all regions |
N=$(wc -l all_regions.bed | awk '{print $1}')

# | regions overlapping with DE gene|
p=$(wc -l subsets/regions_with_de_genes_${t1}vs${t2}.bed | awk '{print $1}')

echo -e "N\tp\tM\tq\tall(N)\texpected(p)\tsampled(M)\tsuccess(q)" > $outfile
for subset in within_100kb_of_sig_db within_tad_with_sig_db within_sig_dc AB AC BC
do
	M=$(wc -l subsets/${subset}_${pair}.bed | awk '{print $1}')
	q=$($intersect -wa -u -a subsets/${subset}_${pair}.bed -b $de_genes | wc -l)
	subset_str=$(echo $subset | sed -r 's/_/ /g')
	echo -e "$N\t$p\t$M\t$q\tall regions\tregions overlapping DE gene\t$subset_str\t$subset_str overlapping DE gene" >> $outfile
done


