import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

c = 18
#marks = ['H3K27ac','H3K27me3','H3K36me3','H3K4me1','H3K4me3','H3K9me3']
marks = ['H3K27ac','H3K4me1','H3K36me3','H3K4me3','H3K27me3','H3K9me3']
bigbed = pd.DataFrame()
for cell in ['NPC','CN']:
	bed = pd.read_csv('bed/chr{:d}_100kb.bed'.format(c),sep="\t",header=None,names=['start','end'],usecols=[1,2],index_col=False)
	bed['chrom'] = 'chr'+str(c)
	cluster= pd.read_csv('dc_output/chr{:d}/cluster_assignment.txt'.format(c),sep="\t",usecols=[cell],index_col=False)
	bed['cluster'] = cluster[cell].values
	for mark in marks: 
		m = np.loadtxt('histone_{}/{}/chr{:d}_100kb.txt'.format(cell,mark,c))
		m /= np.sum(m)
		bed[mark] = m	
	bed['cell'] = cell
	bigbed = pd.concat((bigbed, bed))	
	
df=	bigbed.groupby(['cluster'])[marks].mean() #.reset_index()
print(df)
sns.heatmap(df,cmap='Reds')
plt.tight_layout()
plt.savefig('overall_marks.pdf')

