import pandas as pd
import numpy as np
import sys
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42
#sns.set_context("talk")

resolution = '100kb'
marks = ['H3K27ac','H3K4me1','H3K36me3','H3K4me3','H3K27me3','H3K9me3']
cmpt = ['A','B']
chros = ['chr'+str(i) for i in range(1,20)]
#chros.append('chrX')

df = pd.DataFrame()
for c in chros:
	bed = pd.read_csv('bed/{}_100kb.bed'.format(c),sep="\t",header=None,usecols=[0,1],names=['chrom','start'])
	cmpt_df = pd.read_csv('annotated/{}_compartment_annotation.txt'.format(c),sep="\t")
	for mark in marks: 
		for timepoint in ['NPC','CN']:
			histone = np.loadtxt('histone_{}/{}/{}_{}.txt'.format(timepoint,mark,c,resolution))
			np.nan_to_num(histone,copy=False)
			temp = pd.DataFrame({'start':bed.start,'chrom':bed.chrom,'value':histone})
			temp['mark']=mark
			subcompt_df = cmpt_df[['chrom','start',timepoint]].copy()
			subcompt_df.rename(columns={timepoint:'compartment'},inplace=True)
			temp = pd.merge(subcompt_df,temp,on=['chrom','start'],how='left')
			df = pd.concat((df,temp))

sns.boxplot(data =df, x='mark',hue='compartment',y='value', showfliers=False, hue_order=['A','B'],order=marks)
plt.tight_layout()
plt.savefig('histone_distribution_overall.pdf'.format(timepoint))
