import pandas as pd
import numpy as np

atac = pd.read_csv('../atacseq_chipseq_reads_coverage/H1_atacseq.bed',sep='\t',header=None,names=['chr','start','end','H1'])
atac['end'] +=1

atac_endoderm = pd.read_csv('../atacseq_chipseq_reads_coverage/endoderm_atacseq_qn.bed',sep="\t",header=None,names=['chr','start','end','endoderm'])
atac['endoderm'] = atac_endoderm.endoderm
atac['|log(H1/endoderm)|'] = np.abs(np.log(atac.H1/atac_endoderm.endoderm))

df = pd.DataFrame()
for c in range(1,23):
	sigdiff = pd.read_csv('output/chr{:d}/H1_vs_endoderm_significantly_differential_compartmental_regions.txt'.format(c),sep="\t",header=None,usecols=[1,2],names=['start','end'])
	sigdiff['chr'] = 'chr'+str(c)
	tmp = pd.merge(sigdiff,atac,how='inner',on=['chr','start','end'])
	tmp.dropna(inplace=True)
	df= pd.concat((df,tmp))

df['method'] = 'TGIF-DC'
df.to_csv('sig_diff_compartment_accessibility_diff.txt',sep="\t",index=False,columns =['method','chr','start','end','H1','endoderm','|log(H1/endoderm)|'])

