import pandas as pd
from scipy.stats import ttest_ind
import numpy as np

methods = ['dchic','tgif']
vals = {}
for m in methods:
	tmp = pd.read_csv('{}/sig_diff_compartment_accessibility_diff.txt'.format(m),sep="\t",index_col=False)
	tmp.replace([np.inf,-np.inf],np.nan,inplace=True)
	tmp.dropna(inplace=True)
	vals[m] = tmp['|log(H1/endoderm)|'].values

with open('ttest.txt','w') as o:
	o.write('test\tstatistic\tpval\n')
	a = ttest_ind(vals['tgif'],vals['dchic'],equal_var=False,nan_policy='omit')
	o.write('TGIF=dcHiC\t{:.3f}\t{:e}\n'.format(a.statistic,a.pvalue))
	a = ttest_ind(vals['tgif'],vals['dchic'],equal_var=False,alternative='less',nan_policy='omit')
	o.write('TGIF<dcHiC\t{:.3f}\t{:e}\n'.format(a.statistic,a.pvalue))
	a = ttest_ind(vals['tgif'],vals['dchic'],equal_var=False,alternative='greater',nan_policy='omit')
	o.write('TGIF>dcHiC\t{:.3f}\t{:e}\n'.format(a.statistic,a.pvalue))
