import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

methods = ['dchic','tgif']
df = pd.DataFrame()
for m in methods:
	tmp = pd.read_csv('{}/sig_diff_compartment_accessibility_diff.txt'.format(m),sep="\t",index_col=False)
	df = pd.concat((df,tmp))

sns.boxplot(data=df,x='method',y='|log(H1/endoderm)|',showfliers=False)
plt.savefig('sig_diff_compartment_accessibility_diff.pdf')

