import pandas as pd
import numpy as np
from sklearn import metrics

atac = pd.read_csv('../atacseq_chipseq_reads_coverage/H1_atacseq.bed',sep='\t',header=None,names=['chr','start','end','H1'])
atac['end'] +=1

atac_endoderm = pd.read_csv('../atacseq_chipseq_reads_coverage/endoderm_atacseq_qn.bed',sep="\t",header=None,names=['chr','start','end','endoderm'])
atac['endoderm'] = atac_endoderm.endoderm
atac['|log(H1/endoderm)|'] = np.abs(np.log(atac.H1/atac_endoderm.endoderm))

df = pd.DataFrame()
for c in range(1,23):
	sigdiff= pd.read_csv('output/chr{:d}/fdr_result/differential.intra_sample_group.Filtered.pcQnm.bedGraph'.format(c),sep="\t",usecols=['chr','start','end'])
	tmp= pd.merge(sigdiff, atac, how='inner',on=['chr','start','end'])
	tmp.dropna(inplace=True)
	df = pd.concat((df,tmp))

df['method'] = 'dcHiC'
df.to_csv('sig_diff_compartment_accessibility_diff.txt',sep="\t",index=False,columns =['method','chr','start','end','H1','endoderm','|log(H1/endoderm)|'])


