import pandas as pd
import numpy as np
from sklearn import metrics

atac = pd.read_csv('../atacseq_chipseq_reads_coverage/H1_atacseq.bed',sep='\t',header=None,names=['chrom','start','end','accessibility'])
atac['end'] +=1

o = open('compartment_quality_accessibility.txt','w')
o.write('method\tchrom\tSI\tCH\tDBI\n')

for c in range(1,23):
	bed = pd.read_csv('../bed/H1_chr{:d}_100kb.bed'.format(c),sep="\t",header=None,names=['start','end'],usecols=[1,2])
	bed['chrom'] = 'chr'+str(c)

	cluster= pd.read_csv('output/chr{:d}/cluster_assignment.txt'.format(c),sep="\t",usecols=['H1'])
	bed['cluster'] = cluster.H1.values
	
	df = pd.merge(bed, atac, how='left',on=['chrom','start','end'])
	df.dropna(inplace=True)

	features = df.accessibility.values.reshape(-1,1) 
	clus = df.cluster.values.astype(int) 

	si = metrics.silhouette_score(features,clus)
	ch = metrics.calinski_harabasz_score(features,clus)
	db = 1/metrics.davies_bouldin_score(features,clus)

	o.write('TGIF-DC\tchr{:d}\t{:.3f}\t{:.3f}\t{:.3f}\n'.format(c,si,ch,db))

o.close()
