import pandas as pd
import numpy as np
from sklearn import metrics

atac = pd.read_csv('../atacseq_chipseq_reads_coverage/H1_atacseq.bed',sep='\t',header=None,names=['chrom','start','end','accessibility'])
atac['end'] +=1

o = open('compartment_quality_accessibility.txt','w')
o.write('method\tchrom\tSI\tCH\tDBI\n')

for c in range(1,23):
	score= pd.read_csv('output/chr{:d}/fdr_result/differential.intra_sample_group.pcQnm.bedGraph'.format(c),sep="\t",usecols=['chr','start','end','H1'])
	score.columns = ['chrom','start','end','score']
	score['cluster'] = (score['score'].values > 0).astype(int)
	score= pd.merge(score, atac, how='left',on=['chrom','start','end'])
	score.dropna(inplace=True)

	features = score.accessibility.values.reshape(-1,1) 

	clus = score.cluster.values.astype(int)

	si = metrics.silhouette_score(features,clus)
	ch = metrics.calinski_harabasz_score(features,clus)
	db = 1/metrics.davies_bouldin_score(features,clus)

	o.write('dcHiC\tchr{:d}\t{:.3f}\t{:.3f}\t{:.3f}\n'.format(c,si,ch,db))

o.close()

