import pandas as pd
import numpy as np
from sklearn import metrics

o = open('compartment_quality_oe.txt','w')
o.write('method\tchrom\tSI\tCH\tDBI\n')

for c in range(1,23):
	#tmp = pd.read_csv('../bed/H1_chr{:d}_100kb.bed'.format(c),sep="\t",header=None,names=['start','end'],usecols=[1,2])
	#tmp['chrom'] = 'chr'+str(c)

	cluster= pd.read_csv('output/chr{:d}/cluster_assignment.txt'.format(c),sep="\t",usecols=['H1'])
	#tmp['cluster'] = cluster.H1.values
	cluster.dropna(inplace=True)

	features = np.loadtxt('../oe_matrices/chr{:d}/H1_oe.txt'.format(c))

	si = metrics.silhouette_score(features,cluster.H1.values)
	ch = metrics.calinski_harabasz_score(features,cluster.H1.values)
	db = 1/metrics.davies_bouldin_score(features,cluster.H1.values)

	o.write('TGIF-DC\tchr{:d}\t{:.3f}\t{:.3f}\t{:.3f}\n'.format(c,si,ch,db))

o.close()
