import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

methods = ['cscore','dchic','pca','tgif']
df = pd.DataFrame()
for m in methods:
	tmp = pd.read_csv('{}/compartment_quality_oe.txt'.format(m),sep="\t",index_col=False)
	df = pd.concat((df,tmp))

for metric in ['SI','CH','DBI']: # SI, CH, or DBI (silhouette index, calinski harabasz score, or davies-bouldin index)
	sns.boxplot(data=df,x='method',y=metric,showfliers=False)
	plt.savefig('compartment_quality_oe_{}.pdf'.format(metric))
	plt.clf()

