import pandas as pd
import numpy as np
from sklearn import metrics

o = open('compartment_quality_oe.txt','w')
o.write('method\tchrom\tSI\tCH\tDBI\n')

for c in range(1,23):
	bed = pd.read_csv('../bed/H1_chr{:d}_100kb.bed'.format(c),sep="\t",header=None,names=['start','end'],usecols=[1,2])
	bed['chrom'] = 'chr'+str(c)
	bed['tgif_mask'] = pd.read_csv('../tgif/output/chr{:d}/cluster_assignment.txt'.format(c),sep="\t")['H1'].values
	bed.dropna(inplace=True)

	score= pd.read_csv('output/chr{:d}/fdr_result/differential.intra_sample_group.pcQnm.bedGraph'.format(c),sep="\t",usecols=['chr','start','end','H1'])
	score.columns = ['chrom','start','end','score']
	score['cluster'] = (score['score'].values > 0).astype(int)
	score= pd.merge(bed, score, how='left',on=['chrom','start','end'])

	features = np.loadtxt('../oe_matrices/chr{:d}/H1_oe.txt'.format(c))

	clus = score.cluster.values.astype(int)

	si = metrics.silhouette_score(features,clus)
	ch = metrics.calinski_harabasz_score(features,clus)
	db = 1/metrics.davies_bouldin_score(features,clus)

	o.write('dcHiC\tchr{:d}\t{:.3f}\t{:.3f}\t{:.3f}\n'.format(c,si,ch,db))

o.close()

