import pandas as pd
import numpy as np


for c in range(1,23):
	tmp = pd.read_csv('../bed/H1_chr{:d}_100kb.bed'.format(c),sep="\t",header=None,names=['start','end'],usecols=[1,2])
	tmp['chrom'] = 'chr'+str(c)

	cluster= pd.read_csv('output/chr{:d}/cluster_assignment.txt'.format(c),sep="\t",usecols=['H1'])
	tmp['cluster'] = cluster.H1.values
	tmp.dropna(inplace=True)

	score = np.loadtxt('output/chr{:d}/H1_U.txt'.format(c),usecols=[0])
	tmp['score'] = score	

	tmp.to_csv('H1_chr{:d}_100kb.txt'.format(c),sep="\t",index=False,columns=['chrom','start','end','score','cluster'])

