import pandas as pd
import numpy as np


for c in range(1,23):
	tmp = pd.read_csv('../bed/H1_chr{:d}_100kb.bed'.format(c),sep="\t",header=None,names=['start','end'],usecols=[1,2])
	tmp['chrom'] = 'chr'+str(c)

	na_mask= np.loadtxt('output/H1_chr{:d}_100kb_nonzero_mask.txt'.format(c))
	tmp['na_mask'] = na_mask

	cluster = pd.read_csv('output/H1_chr{:d}_100kb_cluster.txt'.format(c),header=None,names=['cluster'])
	tmp['cluster'] = cluster.cluster.values
	tmp = tmp.loc[tmp.na_mask > 0]

	score = np.loadtxt('output/H1_chr{:d}_100kb_pc1.txt'.format(c))
	tmp['score'] = score	

	tmp.to_csv('H1_chr{:d}_100kb.txt'.format(c),sep="\t",index=False,columns=['chrom','start','end','score','cluster'])

