import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42


df = pd.read_csv('compartment_similarity.txt',sep="\t",index_col=False)
pearsonr = pd.pivot_table(df,index='one',columns='two',values='pearsonr',aggfunc='mean')
randindex = pd.pivot_table(df,index='one',columns='two',values='rand index',aggfunc='mean')

sns.heatmap(pearsonr,cmap='Greens',annot=True,fmt='.2f')
plt.savefig('pearsonr.pdf')
plt.clf()
sns.heatmap(randindex,cmap='Greens',annot=True,fmt='.2f')
plt.savefig('rand_index.pdf')

