import pandas as pd
import numpy as np


for c in range(1,23):
	tmp = pd.read_csv('../bed/H1_chr{:d}_100kb.bed'.format(c),sep="\t",header=None,names=['start','end'],usecols=[1,2])
	tmp['chrom'] = 'chr'+str(c)

	score= pd.read_csv('output/chr{:d}/fdr_result/differential.intra_sample_group.pcQnm.bedGraph'.format(c),sep="\t",usecols=['chr','start','end','H1'])
	score.columns = ['chrom','start','end','score']
	score['cluster'] = (score['score'].values > 0).astype(int)
	tmp = pd.merge(tmp, score, how='left',on=['chrom','start','end'])

	tmp.to_csv('H1_chr{:d}_100kb.txt'.format(c),sep="\t",index=False,columns=['chrom','start','end','score','cluster'])

