import pandas as pd
import numpy as np


bed = pd.read_csv('hg38_100kb.bed',sep="\t",header=None,names=['chrom','start','end'])
bed.start -=1
bed['score'] = np.loadtxt('all_cscore.txt',usecols=[1])
bed['cluster'] = (bed.score.values > 0).astype(int)
print(bed)

for c in range(1,23):
	tmp = pd.read_csv('../bed/H1_chr{:d}_100kb.bed'.format(c),sep="\t",header=None,names=['start','end'],usecols=[1,2])
	tmp['chrom'] = 'chr'+str(c)
	tmp = pd.merge(tmp, bed, how='left',on=['chrom','start','end'])

	tmp.to_csv('H1_chr{:d}_100kb.txt'.format(c),sep="\t",index=False,columns=['chrom','start','end','score','cluster'])

