import pandas as pd
import numpy as np
import sys

o = open('jaccard_per_chro.txt','w')
o.write('chro\tone\ttwo\tintersection\tunion\tjaccard\n')
chros = ['chr'+str(i) for i in range(1,20)]

for chro in chros:
		one_df = pd.read_csv('output/25kb_VCSQRT/ES_{:}_25kb.txt.domain'.format(chro),sep="\t") 
		one_df.dropna(inplace=True)
		one_bd = one_df['to.id'].values.astype(int)
		one = np.zeros(one_bd[-1],dtype=int)
		one[one_bd-1] = 1

		two_df = pd.read_csv('output/25kb_ICED/ES_{:}_25kb.txt.domain'.format(chro),sep="\t") 
		two_df.dropna(inplace=True)
		two_bd = two_df['to.id'].values.astype(int)
		two = np.zeros(two_bd[-1],dtype=int)
		two[two_bd-1] = 1

		u_cnt = np.sum(np.logical_or(one,two))
		i_cnt = np.sum(np.logical_and(one,two)) 
		o.write('{:}\tvcsqrt\ticed\t{:d}\t{:d}\t{:.3f}\n'.format(chro,int(i_cnt),int(u_cnt),i_cnt*1.0/u_cnt))
o.close()
#print(squareform(pdist(sigs)))
#		cnt print= np.sum(sig, axis=0)
#		for i in range(sig.shape[1]):
#			o.write('{}{}\ttask{:d}\t{:d}\n'.format(config,test,i+1,int(cnt[i])))	

