from scipy.spatial.distance import pdist, squareform
import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys

o = open('jaccard_per_chro.txt','w')
o.write('chro\tdepth(%)\tdifferences\tunion\tjaccard\n')
chros = ['chr'+str(i) for i in range(1,23)]

for p in [5,10,25,50]:
	for chro in chros:
		sigs = pd.read_csv('output/output_{:d}perc/{}/significant_boundaries_summit_only.txt'.format(p,chro),sep="\t",index_col=False)
		sigs.dropna(inplace=True)
		sigs = sigs.values.T
		u_cnt = np.sum(np.logical_or(sigs[0],sigs[1]))

		diff = pd.read_csv('output/output_{:d}perc/{}/full_vs_subsample_significantly_differential_boundary_regions.txt'.format(p,chro),sep="\t",header=None, names=['chrom','start','end','abs score diff','pval','adj pval'])
		diff_cnt = diff.start.values.shape[0]

		o.write('{:}\t{:d}\t{:d}\t{:d}\t{:.3f}\n'.format(chro,p,int(diff_cnt),int(u_cnt),1-diff_cnt/u_cnt))

o.close()
#print(squareform(pdist(sigs)))
#		cnt print= np.sum(sig, axis=0)
#		for i in range(sig.shape[1]):
#			o.write('{}{}\ttask{:d}\t{:d}\n'.format(config,test,i+1,int(cnt[i])))	

