import numpy as np
import sys

o = open('jaccard_per_chro.txt','w')
o.write('chro\tdepth(%)\tintersection\tunion\tjaccard\n')
chros = ['chr'+str(i) for i in range(1,23)]

for chro in chros:
	one= np.loadtxt('output/output/{:}.tads'.format(chro),dtype=int).flatten()
	for p in [5,10,25,50]:
		two= np.loadtxt('output/output_{:d}perc/{:}.tads'.format(p,chro),dtype=int).flatten()
		u_cnt = np.union1d(one,two).shape[0]
		i_cnt = np.intersect1d(one,two).shape[0]
		o.write('{:}\t{:d}\t{:d}\t{:d}\t{:.3f}\n'.format(chro,p,int(i_cnt),int(u_cnt),i_cnt/u_cnt))
o.close()
#print(squareform(pdist(sigs)))
#		cnt print= np.sum(sig, axis=0)
#		for i in range(sig.shape[1]):
#			o.write('{}{}\ttask{:d}\t{:d}\n'.format(config,test,i+1,int(cnt[i])))	

