from scipy.spatial.distance import pdist, squareform
import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys

o = open('jaccard_per_chro.txt','w')
o.write('chro\tone\ttwo\tintersection\tunion\tjaccard\n')
chros = ['chr'+str(i) for i in range(1,23)]

for chro in chros:
		one_df = pd.read_csv('output/day00_{:}_10kb_rep1.txt.domain'.format(chro),sep="\t") 
		one_bd = one_df['to.id'].values
		one = np.zeros(one_bd[-1],dtype=int)
		one[one_bd-1] = 1

		two_df = pd.read_csv('output/day00_{:}_10kb_rep2.txt.domain'.format(chro),sep="\t") 
		two_bd = two_df['to.id'].values
		two = np.zeros(two_bd[-1],dtype=int)
		two[two_bd-1] = 1

		u_cnt = np.sum(np.logical_or(one,two))
		i_cnt = np.sum(np.logical_and(one,two)) 
		o.write('{:}\trep1\trep2\t{:d}\t{:d}\t{:.3f}\n'.format(chro,int(i_cnt),int(u_cnt),i_cnt*1.0/u_cnt))
o.close()
#print(squareform(pdist(sigs)))
#		cnt print= np.sum(sig, axis=0)
#		for i in range(sig.shape[1]):
#			o.write('{}{}\ttask{:d}\t{:d}\n'.format(config,test,i+1,int(cnt[i])))	

