from scipy.spatial.distance import pdist, squareform
import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys

o = open('jaccard_per_chro.txt','w')
o.write('chro\tone\ttwo\tsig diff\tunion\tjaccard\n')
chros = ['chr'+str(i) for i in range(1,23)]

for chro in chros:
	sigs = pd.read_csv('output/{}/significant_boundaries_summit_only.txt'.format(chro),sep="\t",index_col=False)
	sigs.dropna(inplace=True)
	sigs = sigs.values.T
	u_cnt = np.sum(np.logical_or(sigs[0],sigs[1]))

	diff = pd.read_csv('output/{}/rep1_vs_rep2_significantly_differential_boundary_regions.txt'.format(chro),sep="\t",header=None, names=['chrom','start','end','abs score diff','pval','adj pval'])
	diff_cnt = diff.start.values.shape[0]

	o.write('{:}\trep1\trep2\t{:d}\t{:d}\t{:.3f}\n'.format(chro,int(diff_cnt),int(u_cnt),1-diff_cnt/u_cnt))
o.close()
#print(squareform(pdist(sigs)))
#		cnt print= np.sum(sig, axis=0)
#		for i in range(sig.shape[1]):
#			o.write('{}{}\ttask{:d}\t{:d}\n'.format(config,test,i+1,int(cnt[i])))	

