from scipy.spatial.distance import pdist, squareform
import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys

o = open('jaccard_per_chro.txt','w')
o.write('chro\tone\ttwo\tintersection\tunion\tjaccard\n')
chros = ['chr'+str(i) for i in range(1,23)]

for chro in chros:
		df = pd.read_csv('output/day00_{:}_10kb.txt'.format(chro),sep="\t")
		u_cnt = df.shape[0] - 1
		int_set = df.loc[df['Differential'] == 'Non-Differential']
		i_cnt = int_set.shape[0] 
		o.write('{:}\trep1\trep2\t{:d}\t{:d}\t{:.3f}\n'.format(chro,int(i_cnt),int(u_cnt),i_cnt/u_cnt))

o.close()
#print(squareform(pdist(sigs)))
#		cnt print= np.sum(sig, axis=0)
#		for i in range(sig.shape[1]):
#			o.write('{}{}\ttask{:d}\t{:d}\n'.format(config,test,i+1,int(cnt[i])))	

