import pandas as pd
import numpy as np
from scipy.stats import hypergeom
import sys

days = [0,2,5,7,15,80]
T = len(days)
chroms = ['chr'+str(i) for i in range(1,23)]
df = pd.DataFrame()

for chrom in chroms:
	bed = pd.read_csv('../bed/{:}_10kb.bed'.format(chrom),sep="\t",usecols=[0,1], header=None, names=['chro','start'],index_col=False)
	bed['chro'] = 'chr' + bed['chro'].astype(str)
	for day in days:
		bed['day'+str(day)] = 0 
	for i in range(0,T-1):
		j = i+1
		day1=days[i]
		day2=days[j]
		boundaries = pd.read_csv('output/day{:}_vs_{:}_{:}_10kb.txt'.format(str(day1).zfill(2),str(day2).zfill(2),chrom), sep="\t",index_col=False)
		boundaries.dropna(inplace=True)
		print(boundaries)	
		common = boundaries.loc[(boundaries.Differential == "Non-Differential")]
		one = boundaries.loc[(boundaries.Enriched_In == "Matrix 1")]
		two = boundaries.loc[(boundaries.Enriched_In == "Matrix 2")]

		day1='day'+str(day1)
		day2='day'+str(day2)
		bed[day1] += bed['start'].isin(common.Boundary).astype(int)
		bed[day1] += bed['start'].isin(one.Boundary).astype(int)
		bed[day2] += bed['start'].isin(common.Boundary).astype(int)
		bed[day2] += bed['start'].isin(two.Boundary).astype(int)
	df = pd.concat((df,bed))

df.to_csv('boundaries_per_timepoint.txt',sep="\t",index=False)
