import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42
sns.set_context("talk")

df = pd.DataFrame()
methods = ['tgif','tadcompare','topdom','grinch','spectraltad']

for m in methods:
	temp = pd.read_csv('{:}/ctcf_enrichment.txt'.format(m),sep="\t",index_col=False)
	df = pd.concat((df,temp))

df.to_csv('ctcf_enrichment.txt',sep="\t",index=False)

df.sort_values(by=['Day','Method'],inplace=True)
sns.barplot(data=df,x='Day',y='fold enrichment',hue='Method')
plt.tight_layout()
plt.savefig('ctcf_enrichment.pdf')
