import pandas as pd
import numpy as np
from sklearn.metrics import precision_recall_fscore_support as prfs
import sys

labels=['task-specific boundary','shared boundary']
x = np.loadtxt('../true_boundaries.txt',dtype=int)
x_pred = pd.read_csv(sys.argv[1],sep="\t",index_col=False)
x_pred.fillna(0, inplace=True)
x_pred = x_pred.values

o = open('accuracy/{}.txt'.format(sys.argv[2]),'w')
o.write("method\tcompared task pairs\tlabel\tprecision\trecall\tf-score\n")
for one in range(4):
	for two in range(one+1,4):
			y_true = x[:,one]+x[:,two]*2
			y_pred = x_pred[:,one]+x_pred[:,two]*2
			precision, recall, fscore, _= prfs(y_true, y_pred,labels=[1,2],average='micro')
			o.write("TGIF\tmatrix{:d} vs {:d}\ttask-specific boundary\t{:.3f}\t{:.3f}\t{:.3f}\n".format(one+1,two+1,precision,recall,fscore))
			precision, recall, fscore, _ = prfs(y_true, y_pred,labels=[3],average='micro')
			o.write("TGIF\tmatrix{:d} vs {:d}\tshared boundary\t{:.3f}\t{:.3f}\t{:.3f}\n".format(one+1,two+1,precision,recall,fscore))
o.close()

