import pandas as pd
import numpy as np
from sklearn.metrics import precision_recall_fscore_support as prfs
import sys

params = sys.argv[1]

labels=['non-boundary','task1-specific boundary','task2-specific boundary','shared boundary']
x = np.loadtxt('../true_boundaries.txt',dtype=bool)

df = pd.read_csv('../simulated.bed',sep="\t",usecols=[1], header=None, names=['start'],index_col=False)
for i in range(1,5):
        bd = pd.read_csv('output/matrix{:d}_{}.txt'.format(i,params), sep="\t", index_col=False, header=None,names=['start'],usecols=[1])
        bd.start -= 40000 
        bd[i] = True
        df = pd.merge(df,bd,on=['start'],how='left')
df.fillna(False,inplace=True)
x_pred = df[range(1,5)].values
print(x_pred)
o = open('accuracy/{}.txt'.format(params),'w')
o.write("method\tcompared task pairs\tlabel\tprecision\trecall\tf-score\n")

for one in range(4):
	for two in range(one+1,4):
		y_true = x[:,one]+x[:,two]*2
		y_pred = x_pred[:,one]+x_pred[:,two]*2
		precision, recall, fscore, _= prfs(y_true, y_pred,labels=[1,2],average='micro')
		o.write("SpectralTAD\tmatrix{:d} vs {:d}\ttask-specific boundary\t{:.3f}\t{:.3f}\t{:.3f}\n".format(one+1,two+1,precision,recall,fscore))
		precision, recall, fscore, _ = prfs(y_true, y_pred,labels=[3],average='micro')
		o.write("SpectralTAD\tmatrix{:d} vs {:d}\tshared boundary\t{:.3f}\t{:.3f}\t{:.3f}\n".format(one+1,two+1,precision,recall,fscore))
o.close()
