import numpy as np
import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
sns.set_context("paper")


#df = pd.read_csv('grinch/variety/accuracy/{}.txt'.format(fname),sep="\t",index_col=False)
df = pd.DataFrame()
for noise in [0.1,0.2,0.3,0.4]:
    for method in ['grinch','spectraltad','tadcompare','tgif_sig_diff','topdom']:
        tmp = pd.read_csv('{}/accuracy/noise{}_sparsity0.txt'.format(method,noise),sep="\t",index_col=False)
        tmp['noise'] = noise
        df = pd.concat((df,tmp))

#df.to_csv('compiled_accuracy.txt',sep="\t",index=False)

palette=['#44bb99', '#bbcc33', '#77aadd', '#ee8866', '#ffaabb'] 
vmin = {'task-specific':0,'shared':0.4}
for btype in ['task-specific','shared']:
    subdf = df.loc[df['label'] == (btype + ' boundary')]
    for metric in ['precision','recall','f-score']:
        fig = plt.figure(figsize=(9,4))
        alpha={'alpha': 0.4}
        ax = sns.boxplot(data=subdf,x='noise',y=metric,hue='method',boxprops=alpha,palette=palette,showfliers=False,medianprops=alpha,capprops=alpha,whiskerprops=alpha)
        sns.stripplot(data=subdf,x='noise',y=metric,hue='method',dodge=True,ax=ax,palette=palette)
        ax.spines['top'].set_visible(False)
        ax.spines['right'].set_visible(False)
        plt.legend(bbox_to_anchor=(1.05, 1), loc=2, borderaxespad=0.)
        #plt.ylim(vmin[btype],1)
        plt.tight_layout()
        plt.savefig('{}_{}.pdf'.format(btype,metric))
        plt.close()

