#!/bin/bash
#SBATCH -A zaugg
#SBATCH --nodes 1
#SBATCH --ntasks 28
#SBATCH --mem 100G
#SBATCH --time 1-00:00:00
#SBATCH -o /g/scb/zaugg/stojanov/basenji/experiments/cluster_outputs/slurm.%N.%j.out
#SBAtCH -e /g/scb/zaugg/stojanov/basenji/experiments/cluster_outputs/slurm.%N.%j.err
#SBATCH --mail-type=END,FAIL
#SBATCH --mail-user=frosina.stojanovska@embl.de
#SBATCH -p gpu-el8
#SBATCH -C gpu=A40
#SBATCH --gres=gpu:1
module load CUDA/11.3.1
module load cuDNN/8.2.1.32-CUDA-11.3.1
export PATH="/g/scb/zaugg/stojanov/development/miniconda3/bin:$PATH"
echo 'activating virtual environment'
source activate /g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/
export PATH="/g/scb/zaugg/stojanov/basenji/bin:$PATH"
export PYTHONPATH="/g/scb/zaugg/stojanov/basenji:$PYTHONPATH"
echo '... done.'
echo 'starting testing'
cd /g/scb/zaugg/stojanov/basenji/bin
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/data/ALT.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/var_preds/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/sequences.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/data/REF.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/ref_preds/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/sequences.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_bin_68h_alt.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/alt_preds_bin_68h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_bin_68h_alt.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_bin_68h_ref.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/ref_preds_bin_68h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_bin_68h_ref.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_bin_1012h_alt.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/alt_preds_bin_1012h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_bin_1012h_alt.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_bin_1012h_ref.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/ref_preds_bin_1012h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_bin_1012h_ref.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_ctcf_68h_alt.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/alt_preds_ctcf_68h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_ctcf_68h_alt.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_ctcf_68h_ref.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/ref_preds_ctcf_68h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_ctcf_68h_ref.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_mef2_68h_alt.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/alt_preds_mef2_68h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_mef2_68h_alt.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_mef2_68h_ref.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/ref_preds_mef2_68h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_mef2_68h_ref.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_mef2_1012h_alt.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/alt_preds_mef2_1012h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_mef2_1012h_alt.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_mef2_1012h_ref.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/ref_preds_mef2_1012h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_mef2_1012h_ref.bed
#/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_twi_24h_alt.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/alt_preds_twi_24h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_twi_24h_alt.bed
/g/scb/zaugg/stojanov/development/miniconda3/envs/basenji/bin/python basenji_predict_bed.py -f /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_twi_24h_ref.fa -o /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/ref_preds_twi_24h/ --rc --shifts "1,0,-1" /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/params.json /g/scb/zaugg/stojanov/basenji/experiments/models/drosophila_l131k_augmented/model_best.h5 /g/scb/zaugg/stojanov/basenji/experiments/variants_predictions/GATK_raw_twi_24h_ref.bed
conda deactivate
echo '...done.'