##################################################
# rules related to calculating 
# the growth of the pangenome
# and changes in the stats of the graph

##########
# auxillary functions

def get_stepwise_stats_for_graph(wildcards):
    num_of_species = len(config["graphs"][wildcards.graph])
    return [f"output/graph/{wildcards.graph}-s{i}.stat" for i in range(1, num_of_species)]

##########
# main rules

rule calculate_graph_stats:
    input:
        segments = "output/graph/{graph}-s{i}.segments",
        stat     = "output/graph/{graph}-s{i}.gfastat",
        bubble   = "output/graph/{graph}-s{i}.bubble"
    output:
        temp("output/graph/{graph}-s{i}.stat.tmp")
    script:
        "../script/calculate_graph_stats.py"

rule add_graph_name_to_graph_stats_file:
    input:
        "output/graph/{graph}-s{i}.stat.tmp"
    output:
        "output/graph/{graph}-s{i}.stat"
    shell:
        "paste -d, <(printf 'graph\n{wildcards.graph}') <(printf 'sample\n{wildcards.i}') {input} > {output}"

rule collate_graph_stats_across_steps:
    input:
        get_stepwise_stats_for_graph   # from: add_graph_name_to_graph_stats_file
    output:
        "output/growth/default_order/{graph}.stat.growth"
    shell:
        "cat <(awk 'NR==1' {input[0]}) <(cat {input} | grep -v '^graph') > {output}"

rule collate_stats_growth_for_all_graphs:
    input:
        expand("output/growth/default_order/{graph}.stat.growth", graph=graph_list)
    output:
        "results/allgraphs.stat.growth.summary"
    shell:
        "cat <(awk 'NR==1' {input[0]}) <(cat {input} | grep -v '^graph') > {output}"

rule extract_graph_stats_at_final_step:
    input:
        "output/growth/default_order/{graph}.stat.growth"
    output:
        temp("output/growth/default_order/{graph}.stat.finalvalue.tmp")
    shell:
        "cat <(head -n1 {input}) <(tail -n1 {input}) > {output}"

rule collate_final_step_graph_stats:
    input:
        expand("output/growth/default_order/{graph}.stat.finalvalue.tmp", graph=graph_list)
    output:
        "results/allgraphs.stat.finalvalue.summary"
    shell:
        "cat <(awk 'NR==1' {input[0]}) <(cat {input} | grep -v '^graph') > {output}"