##################################################
# rules related to calculating 
# contributions of individual samples to pangenome

##########
# auxillary functions

def get_finalstep_stat_bysample_file(wildcards):
    idx_last = len(config["graphs"][wildcards.graph]) - 1
    return f"output/graph/{wildcards.graph}-s{idx_last}.stat.bysample.tmp"

##########
# main rules

rule calculate_graph_stat_bysample:
    input:
        "output/graph/{graph}-s{i}.segments" 
    output:
        "output/graph/{graph}-s{i}.stat.bysample" 
    script:
        "../script/calculate_stats_bysample.py"

rule add_graph_name_to_stat_bysample_file:
    input:
        "output/graph/{graph}-s{i}.stat.bysample" 
    output:
        temp("output/graph/{graph}-s{i}.stat.bysample.tmp")
    shell:
        "paste -d, "
        "<( cat <(printf 'graph,sample\n') "
        "       <(python script/print_text_for_n_rows.py {wildcards.graph},{wildcards.i} $(( $(wc -l < {input}) -1 )) ) " 
        "       | head -n -1 ) "
        "{input} > {output};"

rule get_stat_bysample_at_final_step:
    input:
        get_finalstep_stat_bysample_file
    output:
        temp("results/default_order/{graph}.stat.bysample.finalvalue.tmp")
    shell:
        "cp {input} {output}"

rule collate_final_step_stat_bysample:
    input:
        expand("results/default_order/{graph}.stat.bysample.finalvalue.tmp", graph = graph_list)
    output:
        "results/allgraphs.stat.bysample.finalvalue.summary"
    shell:
        "cat <(awk 'NR==1' {input[0]}) <(cat {input} | grep -v '^graph') > {output}"
