##################################################
# rules related to calculating 
# coverage of individual samples on the backbone

##########
# auxillary functions

def get_finalstep_cov_bysample_file(wildcards):
    idx_last = len(config["graphs"][wildcards.graph]) - 1
    return f"output/graph/{wildcards.graph}-s{idx_last}.cov.bysample.tmp"

##########
# main rules

rule calculate_cov_by_sample:
    input:
        segments = "output/graph/{graph}-s{i}.segments", 
        coverage = "output/coverage/{graph}/summary/s{i}-coverage_values.txt"
    output:
        "output/graph/{graph}-s{i}.cov.bysample" 
    script:
        "../script/calculate_cov_bysample.py"

rule add_graph_name_to_cov_bysample_file:
    input:
        "output/graph/{graph}-s{i}.cov.bysample" 
    output:
        temp("output/graph/{graph}-s{i}.cov.bysample.tmp")
    shell:
        "paste -d, "
        "<( cat <(printf 'graph,sample\n') "
        "       <(python script/print_text_for_n_rows.py {wildcards.graph},{wildcards.i} $(( $(wc -l < {input}) -1 )) ) " 
        "       | head -n -1 ) "
        "{input} > {output};"

rule get_cov_bysample_at_final_step:
    input:
        get_finalstep_cov_bysample_file
    output:
        temp("results/default_order/{graph}.cov.bysample.finalvalue.tmp")
    shell:
        "cp {input} {output}"

rule collate_final_step_cov_bysample:
    input:
        expand("results/default_order/{graph}.cov.bysample.finalvalue.tmp", graph = graph_list)
    output:
        "results/allgraphs.cov.bysample.finalvalue.summary"
    shell:
        "cat <(awk 'NR==1' {input[0]}) <(cat {input} | grep -v '^graph') > {output}"
