##################################################
# rules related to copying  
# some intermediate files for backbone coverage
# used for astCal and mayZeb backboned graphs

##########
# auxillary functions

def get_finalstep_segments_file(wildcards):
    idx_last = len(config["graphs"][wildcards.graph]) - 1
    return f"output/graph/{wildcards.graph}-s{idx_last}.segments"

def get_finalstep_segment_coverages_file(wildcards):
    idx_last = len(config["graphs"][wildcards.graph]) - 1
    return f"output/coverage/{wildcards.graph}/summary/s{idx_last}-coverage_values.txt"

##########
# main rules

rule copy_coverage_files:
    input:
        get_finalstep_segment_coverages_file
    output:
        "results/{graph}-segment_coverages.txt"
    shell:
        "cp {input} {output}"

rule round_up_coverage_and_extract_backbone_values:
    input:
        segments = get_finalstep_segments_file,
        coverage = "results/{graph}-segment_coverages.txt"
    output:
        rounded = "results/{graph}-segment_coverages-corrected.txt",
        bb = "results/{graph}-segments.bb"
    script:
        "../script/round_up_coverage_and_extract_backbone_values.py"

