#!/usr/bin/env bash
#!
#! Name of the job:
#SBATCH -J minigraph
#SBATCH --mail-type=END
#SBATCH -n 64
#SBATCH -N 1
#SBATCH -o "./s_out/slurm-%j_minigraph.txt"
#SBATCH -p 2004
#SBATCH --mem=256G

# FOR CONDA: ACTIVATE YOUR ENVIRONMENT FIRST
# single line command to run, replace as necessary
# export SBATCH_CMD="bash helloworld.sh"; mkdir -p s_out/; sbatch ~/clst/submit_sbatch_big.sh; export SBATCH_CMD=""

# -N node (how many compute units)
# -n tasks (how much each node is pushed, correlated w/  n_cores)
# -c number of cpus (how many processors per task, don't change)


#minigraph -xggs -c -t64 -L50 dir/great_ape/panTro.renamed.fa dir/great_ape/panPan.renamed.fa dir/great_ape/gorGor.renamed.fa dir/great_ape/ponAbe.renamed.fa > output/graph/great_ape.gfa
minigraph -xggs -c -t64 -L50 dir/great_ape/homSapT2T.renamed.fa dir/great_ape/panTro.renamed.fa dir/great_ape/panPan.renamed.fa dir/great_ape/gorGor.renamed.fa dir/great_ape/ponAbe.renamed.fa > output/graph/great_ape.gfa


