# %%
import pandas as pd
from subfunctions import get_non_overlapping_total_length

# %%
# SV file
df_sv = pd.read_table(
    snakemake.input.flex,
    names = "chr,start,end".split(','),
    usecols=[0,1,2], dtype = {'chr': str, 'start': int, 'end': int}
)

# %%
df_genome = pd.read_table(
    snakemake.input.genomewide, 
    names = ["chr", "len"], dtype={'chr': str}
)

# %%
flex_size = get_non_overlapping_total_length(df_sv)
genome_size = sum(df_genome['len'])

# %%
with open(snakemake.output[0], 'w') as o:
    o.write(f"{flex_size} {genome_size}")
