# these are needed but usually not imported explicitly in scripts
library("renv")
library("knitr")
library("rmarkdown")
library("tidyverse")
library("reticulate")

# present in scripts already (may not be complete)
library("plotly")
library("glue")
library("reactable")
library("ggcorrplot")
library("ggridges")
library("dendextend")
library("factoextra")
library("reactable")
library("circlize")
library("dendextend")

# bioconductor packages
library("BiocManager")
library("AnnotationDbi")
library("GenomicFeatures")
library("ComplexHeatmap")
library("regioneR")
library("EnhancedVolcano")
library("BiocVersion")

################################################################################

# here are template commands to bulk install or import packages
# for testing purposes
# note: can support multiple lines

# I bumped into an issue where I may need to disable the LOCK for renv
# to install certain packages
# see this thread:
# https://github.com/StuntsPT/Structure_threader/issues/89

# CRAN
cran_packages <- "renv knitr rmarkdown
  tidyverse reticulate 
  ggcorrplot ggpubr ggridges plotly reactable
  circlize dendextend factoextra "
for (package in unique(strsplit(cran_packages, "\\s+")[[1]])) {
  library(package, character.only = TRUE)
  #renv::install(package)
}


# Bioconductor
bioconductor_packages <- "AnnotationDbi GenomicRanges GenomicFeatures
  ComplexHeatmap regioneR"
for (package in unique(strsplit(bioconductor_packages, "\\s+")[[1]])) {
  library(package, character.only = TRUE)
  #renv::install(paste0('bioc::', package))
}
