source(paste0(Sys.getenv("HOME"), "/code/malawi_transposon/script/R_SCRIPT/modules/frequently_used_items.R"))

get_chrom_sizes <- function(species) {
  assembly_name <- color_schema_species[color_schema_species$species_abrv == species, 'species']
  filepath_chrom_sizes <- glue("{dir_genome}{assembly_name}.chrom.sizes")
  chrom_sizes <- readr::read_delim(filepath_chrom_sizes, delim='\t', col_names=c('chr', 'length'))
  return(chrom_sizes)
}

# data frame of chrom sizes for all the species
chrom_sizes_list <- lapply(color_schema_species$species_abrv, get_chrom_sizes)
names(chrom_sizes_list) <- color_schema_species$species_abrv
