do_reciprocal_intersection <- function(gr_a, gr_b) {
  # gr_a: SV, gr_b: TE (probably doesn't matter)
  # they need to have chrominfo attached
  # returns a dataframe of the intersection sites
  
  # do reciprocal intersect to get all info
  gr_intersect <- findOverlapPairs(gr_a, gr_b, ignore.strand=TRUE) %>% pintersect(ignore.strand=FALSE)
  gr_intersect_reciprocal <- findOverlapPairs(gr_b, gr_a, ignore.strand=TRUE) %>% pintersect(ignore.strand=FALSE)
  tmp_df <- full_join(
    as.data.frame(gr_intersect), as.data.frame(gr_intersect_reciprocal), 
    by=c('seqnames', 'start', 'end', 'width', 'strand', 'hit'))
  
  return(tmp_df)
}


calculate_reduced_length <- function(gr) {
  return(gr %>% GenomicRanges::reduce() %>% width() %>% sum())
}
