################################################################################
# DIRECTORIES

# directory to minigraph files
dir_sv <- paste0(Sys.getenv("HOME"), 
  "/code/malawi_transposon/cloud/graph_genome/malawi_haplochromines/"
)

# directory to RepeatMasker outputs
dir_te <- paste0(Sys.getenv("HOME"), 
  "/code/malawi_transposon/cloud/out/repmask/calliptera_repbase_jun21/"
)

# directory to RepeatMasker outputs (own library)
dir_te_own <- paste0(
  Sys.getenv("HOME"), "/code/malawi_transposon/cloud/out/repmask/otherspecies_repbase_aug22/"
)

# directory of genome FASTA files
dir_genome <- paste0(Sys.getenv("HOME"), 
  "/code/malawi_transposon/cloud/genome/longread-decompress/"
)

# directory to minigraph parameter sweep analysis results
dir_sweep <- paste0(Sys.getenv("HOME"), 
  "/code/malawi_transposon/cloud/workflow/malawi_haplochromines_sweep/results/"
)

dir_sweep_archive <- paste0(Sys.getenv("HOME"), 
  "/code/malawi_transposon/cloud/workflow/malawi_haplochromines_sweep_archive/results/"
)

dir_sweep_0.15 <- paste0(Sys.getenv("HOME"), 
  "/code/malawi_transposon/cloud/workflow/malawi_haplochromines_v0.15_sweep/results/"
)

################################################################################
# COLOR SCHEMA

# color schema for te
color_schema_te <- readr::read_csv(
  paste0(Sys.getenv("HOME"), 
        "/code/malawi_transposon/metadata/te_colorscheme.csv"), comment='#') %>% 
  mutate(color = paste0('#', color), color_dark = paste0('#', color_dark)) %>% 
  filter(!te_family %in% c("RC", "Other", "Simple_repeat"))

# color schema for species
color_schema_species <- readr::read_csv(
  paste0(Sys.getenv("HOME"), 
        "/code/malawi_transposon/metadata/species_colorscheme.csv"), comment='#') %>% 
  mutate(color = paste0('#', color))

################################################################################
# PARAMETERS

# parameters about Lake Malawi population genetics
generation_time <- 3  # yr gen-1
mu <- 3.5e-9          # gen-1 bp-1

# other parameters
num_of_genomes <- nrow(color_schema_species)
